/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.network;

import fi.dy.masa.malilib.network.IClientPayloadData;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.malilib.network.PacketSplitter;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.network.ServuxHudPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_634;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public abstract class ServuxHudHandler<T extends class_8710>
implements IPluginClientPlayHandler<T> {
    private static final ServuxHudHandler<ServuxHudPacket.Payload> INSTANCE = new ServuxHudHandler<ServuxHudPacket.Payload>(){

        public void receive(ServuxHudPacket.Payload payload, ClientPlayNetworking.Context context) {
            INSTANCE.receivePlayPayload(payload, context);
        }
    };
    public static final class_2960 CHANNEL_ID = class_2960.method_60655((String)"servux", (String)"hud_metadata");
    private boolean servuxRegistered;
    private boolean payloadRegistered = false;
    private int failures = 0;
    private static final int MAX_FAILURES = 4;
    private long readingSessionKey = -1L;

    public static ServuxHudHandler<ServuxHudPacket.Payload> getInstance() {
        return INSTANCE;
    }

    public class_2960 getPayloadChannel() {
        return CHANNEL_ID;
    }

    public boolean isPlayRegistered(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            return this.payloadRegistered;
        }
        return false;
    }

    public void setPlayRegistered(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.payloadRegistered = true;
        }
    }

    public <P extends IClientPayloadData> void decodeClientData(class_2960 channel, P data) {
        ServuxHudPacket packet = (ServuxHudPacket)data;
        if (!channel.equals((Object)CHANNEL_ID) || packet == null) {
            return;
        }
        switch (packet.getType()) {
            case PACKET_S2C_METADATA: {
                if (!HudDataManager.getInstance().receiveMetadata(packet.getCompound())) break;
                this.servuxRegistered = true;
                break;
            }
            case PACKET_S2C_SPAWN_DATA: {
                HudDataManager.getInstance().receiveSpawnMetadata(packet.getCompound());
                break;
            }
            case PACKET_S2C_WEATHER_TICK: {
                HudDataManager.getInstance().receiveWeatherData(packet.getCompound());
                break;
            }
            case PACKET_S2C_NBT_RESPONSE_DATA: {
                if (this.readingSessionKey == -1L) {
                    this.readingSessionKey = class_5819.method_43049((long)class_156.method_658()).method_43055();
                }
                MiniHUD.debugLog("ServuxHudHandler#decodeClientData(): received Hud Data Packet Slice of size {} (in bytes) // reading session key [{}]", packet.getTotalSize(), this.readingSessionKey);
                class_2540 fullPacket = PacketSplitter.receive((IPluginClientPlayHandler)this, (long)this.readingSessionKey, (class_2540)packet.getBuffer());
                if (fullPacket == null) break;
                try {
                    this.readingSessionKey = -1L;
                    HudDataManager.getInstance().receiveRecipeManager((class_2487)fullPacket.method_30616(class_2505.method_53898()));
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxHudHandler#decodeClientData(): Hud Data: error reading fullBuffer [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            default: {
                MiniHUD.LOGGER.warn("ServuxHudHandler#decodeClientData(): received unhandled packetType {} of size {} bytes.", (Object)packet.getPacketType(), (Object)packet.getTotalSize());
            }
        }
    }

    public void reset(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID) && this.servuxRegistered) {
            this.servuxRegistered = false;
            this.failures = 0;
            this.readingSessionKey = -1L;
        }
    }

    public void resetFailures(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID) && this.failures > 0) {
            this.failures = 0;
        }
    }

    public void encodeWithSplitter(class_2540 buf, class_634 handler) {
    }

    public void receivePlayPayload(T payload, ClientPlayNetworking.Context ctx) {
        if (payload.method_56479().comp_2242().equals((Object)CHANNEL_ID)) {
            INSTANCE.decodeClientData(CHANNEL_ID, ((ServuxHudPacket.Payload)payload).data());
        }
    }

    public <P extends IClientPayloadData> void encodeClientData(P data) {
        ServuxHudPacket packet = (ServuxHudPacket)data;
        if (!INSTANCE.sendPlayPayload(new ServuxHudPacket.Payload(packet))) {
            if (this.failures > 4) {
                MiniHUD.debugLog("ServuxHudHandler#encodeClientData(): encountered [{}] sendPayload failures, cancelling any Servux join attempt(s)", 4);
                this.servuxRegistered = false;
                INSTANCE.unregisterPlayReceiver();
                HudDataManager.getInstance().onPacketFailure();
            } else {
                ++this.failures;
            }
        }
    }
}

