/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;

public enum LayerMode implements IConfigOptionListEntry
{
    ALL("all", "malilib.gui.label.layer_mode.all"),
    SINGLE_LAYER("single_layer", "malilib.gui.label.layer_mode.single_layer"),
    LAYER_RANGE("layer_range", "malilib.gui.label.layer_mode.layer_range"),
    ALL_BELOW("all_below", "malilib.gui.label.layer_mode.all_below"),
    ALL_ABOVE("all_above", "malilib.gui.label.layer_mode.all_above");

    public static final ImmutableList<LayerMode> VALUES;
    private final String configString;
    private final String translationKey;

    private LayerMode(String configString, String translationKey) {
        this.configString = configString;
        this.translationKey = translationKey;
    }

    @Override
    public String getStringValue() {
        return this.configString;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.translate(this.translationKey, new Object[0]);
    }

    @Override
    public IConfigOptionListEntry cycle(boolean forward) {
        int id = this.ordinal();
        if (forward) {
            if (++id >= LayerMode.values().length) {
                id = 0;
            }
        } else if (--id < 0) {
            id = LayerMode.values().length - 1;
        }
        return LayerMode.values()[id % LayerMode.values().length];
    }

    @Override
    public LayerMode fromString(String name) {
        return LayerMode.fromStringStatic(name);
    }

    public static LayerMode fromStringStatic(String name) {
        for (LayerMode mode : LayerMode.values()) {
            if (!mode.configString.equalsIgnoreCase(name)) continue;
            return mode;
        }
        return ALL;
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])LayerMode.values());
    }
}

