/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.position;

import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.position.BlockRotation;
import javax.annotation.Nullable;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public enum BlockMirror {
    NONE(0, "none", null, class_2415.field_11302),
    X(1, "x", class_2350.class_2351.field_11048, class_2415.field_11301),
    Y(2, "y", class_2350.class_2351.field_11052, class_2415.field_11302),
    Z(3, "z", class_2350.class_2351.field_11051, class_2415.field_11300);

    public static final BlockMirror[] VALUES;
    private final int index;
    private final String name;
    private final String translationKey;
    private final class_2415 vanillaMirror;
    @Nullable
    private final class_2350.class_2351 axis;

    private BlockMirror(@Nullable int index, String name, class_2350.class_2351 axis, class_2415 vanillaMirror) {
        this.index = index;
        this.name = name;
        this.vanillaMirror = vanillaMirror;
        this.translationKey = "malilib.label.block_mirror." + name;
        this.axis = axis;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return StringUtils.translate(this.translationKey, new Object[0]);
    }

    public BlockRotation toRotation(class_2350 direction) {
        if (direction.method_10166() == this.axis) {
            return BlockRotation.CW_180;
        }
        return BlockRotation.NONE;
    }

    public class_2350 mirror(class_2350 direction) {
        if (direction.method_10166() == this.axis) {
            return direction.method_10153();
        }
        return direction;
    }

    public BlockMirror cycle(boolean reverse) {
        int index = this.index + (reverse ? -1 : 1) & 3;
        return VALUES[index];
    }

    public class_2415 getVanillaMirror() {
        return this.vanillaMirror;
    }

    public static BlockMirror byName(String name) {
        for (BlockMirror mirror : VALUES) {
            if (!mirror.name.equalsIgnoreCase(name)) continue;
            return mirror;
        }
        return NONE;
    }

    static {
        VALUES = BlockMirror.values();
    }
}

