/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.time;

import fi.dy.masa.malilib.util.time.TimeFormat;
import fi.dy.masa.malilib.util.time.formatter.TimeFmt;
import fi.dy.masa.malilib.util.time.formatter.TimeFmtFormatted;
import fi.dy.masa.malilib.util.time.formatter.TimeFmtISOLocal;
import fi.dy.masa.malilib.util.time.formatter.TimeFmtISOOffset;
import fi.dy.masa.malilib.util.time.formatter.TimeFmtRFC1123;
import fi.dy.masa.malilib.util.time.formatter.TimeFmtRegular;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TimeFmtType<T extends TimeFmt> {
    public static final TimeFmtType<TimeFmtRegular> REGULAR = TimeFmtType.create(TimeFmtRegular::new, TimeFormat.REGULAR);
    public static final TimeFmtType<TimeFmtISOLocal> ISO_LOCAL = TimeFmtType.create(TimeFmtISOLocal::new, TimeFormat.ISO_LOCAL);
    public static final TimeFmtType<TimeFmtISOOffset> ISO_OFFSET = TimeFmtType.create(TimeFmtISOOffset::new, TimeFormat.ISO_OFFSET);
    public static final TimeFmtType<TimeFmtFormatted> FORMATTED = TimeFmtType.create(TimeFmtFormatted::new, TimeFormat.FORMATTED);
    public static final TimeFmtType<TimeFmtRFC1123> RFC1123 = TimeFmtType.create(TimeFmtRFC1123::new, TimeFormat.RFC1123);
    private final TimeFactory<? extends T> factory;
    private final TimeFormat timeFmt;

    private static <T extends TimeFmt> TimeFmtType<T> create(TimeFactory<? extends T> factory, TimeFormat timeFmt) {
        return new TimeFmtType<T>(factory, timeFmt);
    }

    private TimeFmtType(TimeFactory<? extends T> factory, TimeFormat timeFmt) {
        this.timeFmt = timeFmt;
        this.factory = factory;
    }

    @Nullable
    public T init(TimeFormat fmt) {
        return this.factory.create(fmt);
    }

    public TimeFormat getFmt() {
        return this.timeFmt;
    }

    @FunctionalInterface
    static interface TimeFactory<T extends TimeFmt> {
        public T create(TimeFormat var1);
    }
}

