/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.tweaks;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.restrictions.UsageRestriction;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.config.Hotkeys;
import fi.dy.masa.tweakeroo.mixin.block.IMixinPistonBlock;
import fi.dy.masa.tweakeroo.renderer.RenderUtils;
import fi.dy.masa.tweakeroo.world.FakeChunk;
import fi.dy.masa.tweakeroo.world.FakeWorld;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2674;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_3917;
import net.minecraft.class_3965;
import net.minecraft.class_5455;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class RenderTweaks {
    private static final ConcurrentHashMap<Long, ListMapEntry> SELECTIVE_BLACKLIST = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Long, ListMapEntry> SELECTIVE_WHITELIST = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Long, ListMapEntry> CACHED_LIST = new ConcurrentHashMap();
    public static final int PASSTHROUGH = 1024;
    private static final Color4f colorPos1 = new Color4f(1.0f, 0.0625f, 0.0625f);
    private static final Color4f colorPos2 = new Color4f(0.0625f, 0.0625f, 1.0f);
    private static final Color4f sideColor = Color4f.fromColor((int)0x30FFFFFF);
    private static final Color4f colorOverlapping = new Color4f(1.0f, 0.0625f, 1.0f);
    private static final Color4f colorX = new Color4f(1.0f, 0.25f, 0.25f);
    private static final Color4f colorY = new Color4f(0.25f, 1.0f, 0.25f);
    private static final Color4f colorZ = new Color4f(0.25f, 0.25f, 1.0f);
    private static final Color4f colorLooking = new Color4f(1.0f, 1.0f, 1.0f, 0.6f);
    private static final Color4f colorWhitelist = new Color4f(0.1f, 0.7f, 0.1f, 0.25f);
    private static final Color4f colorBlacklist = new Color4f(0.7f, 0.1f, 0.1f, 0.25f);
    private static Color4f colorSearch = new Color4f(0.9f, 0.0f, 0.7f, 0.25f);
    public static Selection AREA_SELECTION = new Selection();
    public static class_2338 posLookingAt = null;
    public static long LAST_CHECK = 0L;
    private static UsageRestriction.ListType previousType = (UsageRestriction.ListType)Configs.Lists.SELECTIVE_BLOCKS_LIST_TYPE.getOptionListValue();
    private static boolean previousSelectiveToggle = FeatureToggle.TWEAK_SELECTIVE_BLOCKS_RENDERING.getBooleanValue();
    private static class_5455.class_6890 dynamicRegistryManager;
    private static FakeWorld fakeWorld;

    public static void setDynamicRegistryManager(@Nullable class_5455.class_6890 immutable) {
        if (immutable == null) {
            return;
        }
        dynamicRegistryManager = immutable;
    }

    public static class_5455.class_6890 getDynamicRegistryManager() {
        return dynamicRegistryManager;
    }

    public static void resetWorld(int loadDistance) {
        fakeWorld = new FakeWorld((class_5455)dynamicRegistryManager, loadDistance);
    }

    public static FakeWorld getFakeWorld() {
        return fakeWorld;
    }

    public static void onTick() {
        class_310 mc = class_310.method_1551();
        if (FeatureToggle.TWEAK_AREA_SELECTOR.getBooleanValue()) {
            if (mc.field_1690.field_1886.method_1434()) {
                RenderTweaks.select(false);
            }
            if (mc.field_1690.field_1904.method_1434()) {
                RenderTweaks.select(true);
            }
        }
    }

    public static void render(Matrix4f posMatrix, Matrix4f projMatrix, class_3695 profiler) {
        class_310 mc = class_310.method_1551();
        float expand = 0.001f;
        float lineWidthBlockBox = 2.0f;
        if (FeatureToggle.TWEAK_AREA_SELECTOR.getBooleanValue() || FeatureToggle.TWEAK_SELECTIVE_BLOCKS_RENDER_OUTLINE.getBooleanValue()) {
            if (FeatureToggle.TWEAK_AREA_SELECTOR.getBooleanValue()) {
                RenderTweaks.updateLookingAt();
            }
            profiler.method_15396("tweakeroo_render_tweaks");
            Matrix4fStack globalStack = RenderSystem.getModelViewStack();
            globalStack.pushMatrix();
            fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            fi.dy.masa.malilib.render.RenderUtils.setupBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-1.2f, (float)-0.2f);
            if (FeatureToggle.TWEAK_SELECTIVE_BLOCKS_RENDER_OUTLINE.getBooleanValue()) {
                RenderTweaks.renderLists(posMatrix, projMatrix, profiler);
            }
            if (FeatureToggle.TWEAK_AREA_SELECTOR.getBooleanValue()) {
                if (posLookingAt != null) {
                    RenderUtils.renderBlockOutline(posLookingAt, expand, lineWidthBlockBox, colorLooking, mc);
                }
                RenderTweaks.renderSelection(posMatrix, projMatrix, profiler, AREA_SELECTION);
            }
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            globalStack.popMatrix();
            RenderSystem.depthMask((boolean)true);
            profiler.method_15407();
        }
    }

    private static void renderLists(Matrix4f posMatrix, Matrix4f projMatrix, class_3695 profiler) {
        float expand = 0.001f;
        float lineWidthBlockBox = 2.0f;
        class_310 mc = class_310.method_1551();
        profiler.method_15396("lists");
        for (ListMapEntry entry : SELECTIVE_BLACKLIST.values()) {
            RenderUtils.renderBlockOutline(entry.currentPosition, expand, lineWidthBlockBox, colorBlacklist, mc);
        }
        for (ListMapEntry entry : SELECTIVE_WHITELIST.values()) {
            RenderUtils.renderBlockOutline(entry.currentPosition, expand, lineWidthBlockBox, colorWhitelist, mc);
        }
        profiler.method_15407();
    }

    public static void updateLookingAt() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1765 != null && mc.field_1765 instanceof class_3965) {
            posLookingAt = ((class_3965)mc.field_1765).method_17777();
            if (Hotkeys.AREA_SELECTION_OFFSET.getKeybind().isKeybindHeld()) {
                posLookingAt = posLookingAt.method_10093(((class_3965)mc.field_1765).method_17780());
            }
        } else {
            posLookingAt = null;
        }
    }

    public static void select(boolean pos2) {
        if (posLookingAt == null) {
            return;
        }
        if (pos2) {
            RenderTweaks.AREA_SELECTION.pos2 = posLookingAt;
        } else {
            RenderTweaks.AREA_SELECTION.pos1 = posLookingAt;
        }
    }

    public static boolean isInSelection(class_2338 pos) {
        int minX = Math.min(RenderTweaks.AREA_SELECTION.pos1.method_10263(), RenderTweaks.AREA_SELECTION.pos2.method_10263());
        int minY = Math.min(RenderTweaks.AREA_SELECTION.pos1.method_10264(), RenderTweaks.AREA_SELECTION.pos2.method_10264());
        int minZ = Math.min(RenderTweaks.AREA_SELECTION.pos1.method_10260(), RenderTweaks.AREA_SELECTION.pos2.method_10260());
        int maxX = Math.max(RenderTweaks.AREA_SELECTION.pos1.method_10263(), RenderTweaks.AREA_SELECTION.pos2.method_10263());
        int maxY = Math.max(RenderTweaks.AREA_SELECTION.pos1.method_10264(), RenderTweaks.AREA_SELECTION.pos2.method_10264());
        int maxZ = Math.max(RenderTweaks.AREA_SELECTION.pos1.method_10260(), RenderTweaks.AREA_SELECTION.pos2.method_10260());
        return pos.method_10263() >= minX && pos.method_10263() <= maxX && pos.method_10264() >= minY && pos.method_10264() <= maxY && pos.method_10260() >= minZ && pos.method_10260() <= maxZ;
    }

    public static void addSelectionToList() {
        ConcurrentHashMap<Long, ListMapEntry> list;
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        if (RenderTweaks.AREA_SELECTION.pos1 == null || RenderTweaks.AREA_SELECTION.pos2 == null) {
            InfoUtils.printActionbarMessage((String)"Please set an area first", (Object[])new Object[0]);
            return;
        }
        UsageRestriction.ListType type = (UsageRestriction.ListType)Configs.Lists.SELECTIVE_BLOCKS_LIST_TYPE.getOptionListValue();
        if (type == UsageRestriction.ListType.NONE) {
            InfoUtils.printActionbarMessage((String)"No list selected", (Object[])new Object[0]);
            return;
        }
        Iterator iterator = class_2338.method_10097((class_2338)RenderTweaks.AREA_SELECTION.pos1, (class_2338)RenderTweaks.AREA_SELECTION.pos2).iterator();
        int count = 0;
        ConcurrentHashMap<Long, ListMapEntry> concurrentHashMap = list = type == UsageRestriction.ListType.WHITELIST ? SELECTIVE_WHITELIST : SELECTIVE_BLACKLIST;
        while (iterator.hasNext()) {
            class_2338 pos = ((class_2338)iterator.next()).method_10062();
            if (!Configs.Generic.AREA_SELECTION_USE_ALL.getBooleanValue() && mc.field_1687.method_8320(pos).method_26215() || list.containsKey(pos.method_10063())) continue;
            list.put(pos.method_10063(), new ListMapEntry(pos));
            ++count;
        }
        RenderTweaks.rebuildStrings();
        InfoUtils.printActionbarMessage((String)("Added " + count + " blocks"), (Object[])new Object[0]);
    }

    public static void removeSelectionFromList() {
        ConcurrentHashMap<Long, ListMapEntry> list;
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        if (RenderTweaks.AREA_SELECTION.pos1 == null || RenderTweaks.AREA_SELECTION.pos2 == null) {
            InfoUtils.printActionbarMessage((String)"Please set an area first", (Object[])new Object[0]);
            return;
        }
        UsageRestriction.ListType type = (UsageRestriction.ListType)Configs.Lists.SELECTIVE_BLOCKS_LIST_TYPE.getOptionListValue();
        if (type == UsageRestriction.ListType.NONE) {
            InfoUtils.printActionbarMessage((String)"No list selected", (Object[])new Object[0]);
            return;
        }
        Iterator iterator = class_2338.method_10097((class_2338)RenderTweaks.AREA_SELECTION.pos1, (class_2338)RenderTweaks.AREA_SELECTION.pos2).iterator();
        int count = 0;
        ConcurrentHashMap<Long, ListMapEntry> concurrentHashMap = list = type == UsageRestriction.ListType.WHITELIST ? SELECTIVE_WHITELIST : SELECTIVE_BLACKLIST;
        while (iterator.hasNext()) {
            class_2338 pos = (class_2338)iterator.next();
            if (!list.containsKey(pos.method_10063())) continue;
            list.remove(pos.method_10063());
            ++count;
        }
        RenderTweaks.rebuildStrings();
        InfoUtils.printActionbarMessage((String)("Removed " + count + " blocks"), (Object[])new Object[0]);
    }

    public static void renderSelection(Matrix4f posMatrix, Matrix4f projMatrix, class_3695 profiler, Selection selection) {
        class_2338 pos1 = selection.pos1;
        class_2338 pos2 = selection.pos2;
        if (pos1 == null && pos2 == null) {
            return;
        }
        float expand = 0.001f;
        float lineWidthBlockBox = 2.0f;
        float lineWidthArea = 1.5f;
        class_310 mc = class_310.method_1551();
        profiler.method_15396("selection");
        if (pos1 != null && pos2 != null) {
            if (!pos1.equals((Object)pos2)) {
                RenderUtils.renderAreaOutlineNoCorners(pos1, pos2, lineWidthArea, colorX, colorY, colorZ, mc);
                RenderUtils.renderAreaSides(pos1, pos2, sideColor, posMatrix, mc);
                RenderUtils.renderBlockOutline(pos1, expand, lineWidthBlockBox, colorPos1, mc);
                RenderUtils.renderBlockOutline(pos2, expand, lineWidthBlockBox, colorPos2, mc);
            } else {
                RenderUtils.renderBlockOutlineOverlapping(pos1, expand, lineWidthBlockBox, colorPos1, colorPos2, colorOverlapping, posMatrix, mc);
            }
        } else {
            if (pos1 != null) {
                RenderUtils.renderBlockOutline(pos1, expand, lineWidthBlockBox, colorPos1, mc);
            }
            if (pos2 != null) {
                RenderUtils.renderBlockOutline(pos2, expand, lineWidthBlockBox, colorPos2, mc);
            }
        }
        profiler.method_15407();
    }

    public static void onPistonEvent(class_2680 state, class_1937 world, class_2338 pos, int type, int data) {
        if (!Configs.Generic.SELECTIVE_BLOCKS_TRACK_PISTONS.getBooleanValue() || !FeatureToggle.TWEAK_SELECTIVE_BLOCKS_RENDERING.getBooleanValue() && !FeatureToggle.TWEAK_SELECTIVE_BLOCKS_RENDER_OUTLINE.getBooleanValue() || SELECTIVE_WHITELIST.size() == 0 && SELECTIVE_BLACKLIST.size() == 0) {
            return;
        }
        if (type == 2) {
            return;
        }
        class_2350 pushDirection = class_2350.method_10143((int)(data & 7));
        class_2674 pistonHandler = new class_2674(world, pos, pushDirection, type == 0);
        class_2680 state2 = null;
        class_2586 entity = null;
        class_2586 entity2 = null;
        if (type != 0 && !((IMixinPistonBlock)state.method_26204()).getSticky()) {
            return;
        }
        if (type != 0) {
            state2 = world.method_8320(pos.method_10093(pushDirection));
            entity = world.method_8321(pos);
            entity2 = world.method_8321(pos.method_10093(pushDirection));
            world.method_8652(pos, class_2246.field_10124.method_9564(), 16);
            world.method_8652(pos.method_10093(pushDirection), class_2246.field_10124.method_9564(), 16);
        }
        boolean moveSuccess = pistonHandler.method_11537();
        if (type != 0) {
            world.method_8652(pos, state, 16);
            world.method_8652(pos.method_10093(pushDirection), state2, 16);
            if (entity != null) {
                world.method_8438(entity);
            }
            if (entity2 != null) {
                world.method_8438(entity2);
            }
        }
        boolean attatchedWhitelist = SELECTIVE_WHITELIST.containsKey(pos.method_10079(pushDirection, type == 0 ? 1 : 2).method_10063());
        boolean attatchedBlacklist = SELECTIVE_BLACKLIST.containsKey(pos.method_10079(pushDirection, type == 0 ? 1 : 2).method_10063());
        boolean whitelisted = SELECTIVE_WHITELIST.containsKey(pos.method_10063());
        boolean blacklisted = SELECTIVE_BLACKLIST.containsKey(pos.method_10063());
        if (type == 0) {
            if (whitelisted) {
                if (attatchedWhitelist) {
                    RenderTweaks.SELECTIVE_WHITELIST.get((Object)Long.valueOf((long)pos.method_10093((class_2350)pushDirection).method_10063())).preserve = true;
                } else {
                    SELECTIVE_WHITELIST.put(pos.method_10079(pushDirection, 1).method_10063(), new ListMapEntry(pos.method_10079(pushDirection, 1)));
                }
            }
            if (blacklisted) {
                if (attatchedBlacklist) {
                    RenderTweaks.SELECTIVE_BLACKLIST.get((Object)Long.valueOf((long)pos.method_10093((class_2350)pushDirection).method_10063())).preserve = true;
                } else {
                    SELECTIVE_BLACKLIST.put(pos.method_10079(pushDirection, 1).method_10063(), new ListMapEntry(pos.method_10079(pushDirection, 1)));
                }
            }
        }
        if (moveSuccess) {
            List movedBlocks = pistonHandler.method_11541();
            ArrayList<ListMapEntry> toMoveWhitelist = new ArrayList<ListMapEntry>();
            ArrayList<ListMapEntry> toMoveBlacklist = new ArrayList<ListMapEntry>();
            ArrayList<ListMapEntry> toAddWhitelist = new ArrayList<ListMapEntry>();
            ArrayList<ListMapEntry> toAddBlacklist = new ArrayList<ListMapEntry>();
            for (class_2338 class_23382 : movedBlocks) {
                ListMapEntry entry;
                long key = class_23382.method_10063();
                if (SELECTIVE_WHITELIST.containsKey(key)) {
                    entry = SELECTIVE_WHITELIST.get(key);
                    toMoveWhitelist.add(entry);
                    SELECTIVE_WHITELIST.remove(key);
                    if (entry.preserve) {
                        entry.preserve = false;
                        toAddWhitelist.add(new ListMapEntry(class_23382));
                    }
                }
                if (!SELECTIVE_BLACKLIST.containsKey(key)) continue;
                entry = SELECTIVE_BLACKLIST.get(key);
                toMoveBlacklist.add(entry);
                SELECTIVE_BLACKLIST.remove(key);
                if (!entry.preserve) continue;
                entry.preserve = false;
                toAddBlacklist.add(new ListMapEntry(class_23382));
            }
            for (ListMapEntry listMapEntry : toMoveWhitelist) {
                listMapEntry.currentPosition = listMapEntry.currentPosition.method_10079(pushDirection, type == 0 ? 1 : -1);
                if (SELECTIVE_WHITELIST.containsKey(listMapEntry.currentPosition.method_10063())) {
                    listMapEntry.preserve = true;
                }
                SELECTIVE_WHITELIST.put(listMapEntry.currentPosition.method_10063(), listMapEntry);
            }
            for (ListMapEntry listMapEntry : toMoveBlacklist) {
                listMapEntry.currentPosition = listMapEntry.currentPosition.method_10079(pushDirection, type == 0 ? 1 : -1);
                if (SELECTIVE_BLACKLIST.containsKey(listMapEntry.currentPosition.method_10063())) {
                    listMapEntry.preserve = true;
                }
                SELECTIVE_BLACKLIST.put(listMapEntry.currentPosition.method_10063(), listMapEntry);
            }
            for (ListMapEntry listMapEntry : toAddWhitelist) {
                SELECTIVE_WHITELIST.put(listMapEntry.currentPosition.method_10063(), listMapEntry);
            }
            for (ListMapEntry listMapEntry : toAddBlacklist) {
                SELECTIVE_BLACKLIST.put(listMapEntry.currentPosition.method_10063(), listMapEntry);
            }
        }
        RenderTweaks.reloadSelective();
    }

    public static boolean isPositionValidForRendering(class_2338 pos) {
        return RenderTweaks.isPositionValidForRendering(pos.method_10063());
    }

    public static boolean isPositionValidForRendering(long key) {
        if (!FeatureToggle.TWEAK_SELECTIVE_BLOCKS_RENDERING.getBooleanValue()) {
            return true;
        }
        switch ((UsageRestriction.ListType)Configs.Lists.SELECTIVE_BLOCKS_LIST_TYPE.getOptionListValue()) {
            case NONE: {
                return true;
            }
            case WHITELIST: {
                return SELECTIVE_WHITELIST.containsKey(key);
            }
            case BLACKLIST: {
                return !SELECTIVE_BLACKLIST.containsKey(key);
            }
        }
        return false;
    }

    public static void rebuildLists() {
        SELECTIVE_BLACKLIST.clear();
        SELECTIVE_WHITELIST.clear();
        RenderTweaks.putMapFromString(SELECTIVE_BLACKLIST, Configs.Lists.SELECTIVE_BLOCKS_BLACKLIST.getStringValue());
        RenderTweaks.putMapFromString(SELECTIVE_WHITELIST, Configs.Lists.SELECTIVE_BLOCKS_WHITELIST.getStringValue());
        RenderTweaks.reloadSelective();
    }

    public static void updateSelectiveAtPos(class_2338 pos) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        class_2680 state = mc.field_1687.method_8320(pos);
        if (RenderTweaks.isPositionValidForRendering(pos)) {
            class_2680 originalState;
            if (state.method_26215() && !(originalState = fakeWorld.method_8320(pos)).method_26215()) {
                class_2586 be = fakeWorld.method_8321(pos);
                fakeWorld.method_8501(pos, class_2246.field_10124.method_9564());
                mc.field_1687.method_8652(pos, originalState, 1043);
                if (be != null) {
                    mc.field_1687.method_8438(be);
                }
            }
        } else if (!state.method_26215()) {
            class_2586 be = mc.field_1687.method_8321(pos);
            mc.field_1687.method_8652(pos, class_2246.field_10124.method_9564(), 1043);
            RenderTweaks.setFakeBlockState((class_1937)mc.field_1687, pos, state, be);
        }
    }

    public static void reloadSelective() {
        class_310.method_1551().execute(RenderTweaks::reloadSelectiveInternal);
    }

    public static void reloadSelectiveInternal() {
        class_310 mc = class_310.method_1551();
        UsageRestriction.ListType listtype = (UsageRestriction.ListType)Configs.Lists.SELECTIVE_BLOCKS_LIST_TYPE.getOptionListValue();
        boolean toggle = FeatureToggle.TWEAK_SELECTIVE_BLOCKS_RENDERING.getBooleanValue();
        if (mc.field_1687 == null) {
            CACHED_LIST.clear();
            if (listtype != UsageRestriction.ListType.NONE) {
                ConcurrentHashMap<Long, ListMapEntry> list = listtype == UsageRestriction.ListType.WHITELIST ? SELECTIVE_WHITELIST : SELECTIVE_BLACKLIST;
                for (ListMapEntry entry : list.values()) {
                    CACHED_LIST.put(entry.currentPosition.method_10063(), entry);
                }
            }
            previousSelectiveToggle = toggle;
            previousType = listtype;
            return;
        }
        if (listtype != previousType || toggle != previousSelectiveToggle) {
            class_1923 center = fakeWorld.getChunkManager().getChunkMapCenter();
            int radius = fakeWorld.getChunkManager().getRadius();
            class_2338.class_2339 pos = new class_2338.class_2339();
            for (int cx = center.field_9181 - radius; cx <= center.field_9181 + radius; ++cx) {
                for (int cz = center.field_9180 - radius; cz <= center.field_9180 + radius; ++cz) {
                    class_2818 chunk = mc.field_1687.method_2935().method_2857(cx, cz, class_2806.field_12803, false);
                    FakeChunk fakeChunk = fakeWorld.getChunkManager().getChunkIfExists(cx, cz);
                    if (chunk == null || fakeChunk == null) continue;
                    class_1923 cpos = chunk.method_12004();
                    class_2826[] sections = chunk.method_12006();
                    class_2826[] fakeSections = fakeChunk.method_12006();
                    for (int i = 0; i < sections.length; ++i) {
                        class_2826 section = sections[i];
                        if (section.method_38292() && fakeSections[i].method_38292()) continue;
                        for (int x = 0; x < 16; ++x) {
                            for (int y = 0; y < 16; ++y) {
                                for (int z = 0; z < 16; ++z) {
                                    pos.method_10103(x + cpos.method_8326(), y + fakeWorld.method_31604(i), z + cpos.method_8328());
                                    RenderTweaks.updateSelectiveAtPos((class_2338)pos);
                                }
                            }
                        }
                    }
                }
            }
            CACHED_LIST.clear();
            if (listtype != UsageRestriction.ListType.NONE) {
                ConcurrentHashMap<Long, ListMapEntry> list = listtype == UsageRestriction.ListType.WHITELIST ? SELECTIVE_WHITELIST : SELECTIVE_BLACKLIST;
                for (ListMapEntry entry : list.values()) {
                    CACHED_LIST.put(entry.currentPosition.method_10063(), entry);
                }
            }
        } else if (listtype != UsageRestriction.ListType.NONE) {
            ConcurrentHashMap<Long, ListMapEntry> list = listtype == UsageRestriction.ListType.WHITELIST ? SELECTIVE_WHITELIST : SELECTIVE_BLACKLIST;
            Iterator<ListMapEntry> iterator = CACHED_LIST.values().iterator();
            while (iterator.hasNext()) {
                ListMapEntry entry = iterator.next();
                if (list.containsKey(entry.currentPosition.method_10063())) continue;
                RenderTweaks.updateSelectiveAtPos(entry.currentPosition);
                iterator.remove();
            }
            for (ListMapEntry entry : list.values()) {
                if (CACHED_LIST.containsKey(entry.currentPosition.method_10063())) continue;
                RenderTweaks.updateSelectiveAtPos(entry.currentPosition);
                CACHED_LIST.put(entry.currentPosition.method_10063(), entry);
            }
        }
        previousSelectiveToggle = toggle;
        previousType = listtype;
    }

    public static void onLightUpdateEvent(int chunkX, int chunkZ, CallbackInfo ci) {
    }

    public static void rebuildStrings() {
        String whitelist = RenderTweaks.getStringFromMap(SELECTIVE_WHITELIST);
        String blacklist = RenderTweaks.getStringFromMap(SELECTIVE_BLACKLIST);
        Configs.Lists.SELECTIVE_BLOCKS_WHITELIST.setValueFromString(whitelist);
        Configs.Lists.SELECTIVE_BLOCKS_BLACKLIST.setValueFromString(blacklist);
    }

    public static void putMapFromString(ConcurrentHashMap<Long, ListMapEntry> map, String str) {
        String[] parts;
        for (String part : parts = str.split("\\|")) {
            String[] nums = part.split(",");
            if (nums.length < 3) continue;
            try {
                int x = Integer.parseInt(nums[0]);
                int y = Integer.parseInt(nums[1]);
                int z = Integer.parseInt(nums[2]);
                class_2338 pos = new class_2338(x, y, z);
                map.put(pos.method_10063(), new ListMapEntry(pos, true));
            }
            catch (NumberFormatException e) {
                Tweakeroo.LOGGER.warn("Error while parsing int: {}", (Object)e.toString());
            }
        }
    }

    public static String getStringFromMap(ConcurrentHashMap<Long, ListMapEntry> map) {
        Iterator<ListMapEntry> iterator = map.values().iterator();
        ArrayList<CallSite> entries = new ArrayList<CallSite>();
        while (iterator.hasNext()) {
            ListMapEntry entry = iterator.next();
            entries.add((CallSite)((Object)(entry.originalPosition.method_10263() + "," + entry.originalPosition.method_10264() + "," + entry.originalPosition.method_10260())));
        }
        return String.join((CharSequence)"|", entries);
    }

    public static Color4f getColorSearch() {
        return colorSearch;
    }

    public static void setColorSearch(Color4f colorSearch) {
        RenderTweaks.colorSearch = colorSearch;
    }

    public static boolean onOpenScreen(class_2561 name, class_3917<?> screenHandlerType, int syncId) {
        LAST_CHECK = System.currentTimeMillis();
        return true;
    }

    public static void loadFakeChunk(int x, int z) {
        fakeWorld.getChunkManager().loadChunk(x, z);
    }

    public static void setFakeBlockState(class_1937 realWorld, class_2338 pos, class_2680 state, class_2586 be) {
        fakeWorld.method_8652(pos, state, 0);
        if (be != null) {
            fakeWorld.method_8438(be);
            be.method_31662(realWorld);
        }
    }

    public static void unloadFakeChunk(int x, int z) {
        fakeWorld.getChunkManager().unloadChunk(x, z);
    }

    static {
        fakeWorld = null;
    }

    public static class Selection {
        public class_2338 pos1 = null;
        public class_2338 pos2 = null;
    }

    public static class ListMapEntry {
        public final class_2338 originalPosition;
        public class_2338 currentPosition;
        public boolean preserve = false;

        ListMapEntry(class_2338 pos) {
            this.originalPosition = pos;
            this.currentPosition = pos;
        }

        ListMapEntry(class_2338 pos, boolean preserve) {
            this(pos);
            this.preserve = preserve;
        }
    }
}

