#!/bin/python3

# Simple script to automate pass creation
# Creates an empty main file in program/ and a file in world*/ that includes the main file

import argparse
import os

def add_pass(name):
    # Check if file exists and exit to prevent accidental overwrites
    paths = ["shaders/program/" + name, "shaders/world0/" + name, "shaders/world1/" + name, "shaders/world-1/" + name]
    for path in paths:
        if os.path.exists(path):
            print("This file already exists!")
            exit(1)

    with open(paths[0], 'w') as file:
        pass

    with open(paths[1], 'w') as file:
        file.write('#version 120\n#define DIMENSION_OVERWORLD\n\n#include \"/program/' + name + '\"')

    with open(paths[2], 'w') as file:
        file.write('#version 120\n#define DIMENSION_END\n\n#include \"/program/' + name + '\"')

    with open(paths[3], 'w') as file:
        file.write('#version 120\n#define DIMENSION_NETHER\n\n#include \"/program/' + name + '\"')

    print(f"File '{name}' created successfully.")

def del_pass(name):
    paths = ["shaders/program/", "shaders/world0/", "shaders/world1/", "shaders/world-1/"]
    for path in paths:
        f = path + name
        if os.path.exists(f):
            os.remove(f)
    print(f"File '{name}' deleted successfully.")



### Main (i forgot the syntax)

# Check if we are in the root directory
current_path = os.getcwd()
world_path = os.path.join(current_path, "shaders/world0")
if not os.path.isdir(world_path):
    print("You need to be in the root directory of the shader!")
    print("You are now in", current_path)
    exit(1)

# Parse arguments
parser = argparse.ArgumentParser(description = "Simple script to automate pass creation")

subparser = parser.add_subparsers()
parser_add = subparser.add_parser("add")
parser_add.set_defaults(func = add_pass)
parser_del = subparser.add_parser("del")
parser_del.set_defaults(func = del_pass)

parser.add_argument("name", nargs=1, metavar="name")

args = parser.parse_args()
args.func(args.name[0])

