// This file initializes the 4 varyings SKY_TOP, SKY_GROUND, SUN_AMBIENT and SUN_DIRECT
// Call init_colors() in the vertex stage if you need to use these

void get_sky_color() {
    const vec3 SKY_TOP_NOON = to_linear(vec3(NOON_SKY_T_R, NOON_SKY_T_G, NOON_SKY_T_B));
    const vec3 SKY_TOP_SUNRISE = to_linear(vec3(SUNRISE_SKY_T_R, SUNRISE_SKY_T_G, SUNRISE_SKY_T_B));
    const vec3 SKY_TOP_SUNSET = to_linear(vec3(SUNSET_SKY_T_R, SUNSET_SKY_T_G, SUNSET_SKY_T_B));
    const vec3 SKY_TOP_NIGHT = to_linear(vec3(NIGHT_SKY_T_R, NIGHT_SKY_T_G, NIGHT_SKY_T_B));

    const vec3 SKY_GROUND_NOON = to_linear(vec3(NOON_SKY_G_R, NOON_SKY_G_G, NOON_SKY_G_B));
    const vec3 SKY_GROUND_SUNRISE = to_linear(vec3(SUNRISE_SKY_G_R, SUNRISE_SKY_G_G, SUNRISE_SKY_G_B));
    const vec3 SKY_GROUND_SUNSET = to_linear(vec3(SUNSET_SKY_G_R, SUNSET_SKY_G_G, SUNSET_SKY_G_B));
    const vec3 SKY_GROUND_NIGHT = to_linear(vec3(NIGHT_SKY_G_R, NIGHT_SKY_G_G, NIGHT_SKY_G_B));

    SKY_TOP = SKY_TOP_SUNRISE*sunriseStrength+SKY_TOP_NOON*dayStrength+SKY_TOP_SUNSET*sunsetStrength+SKY_TOP_NIGHT*nightStrength;
    SKY_GROUND = SKY_GROUND_SUNRISE*sunriseStrength+SKY_GROUND_NOON*dayStrength+SKY_GROUND_SUNSET*sunsetStrength+SKY_GROUND_NIGHT*nightStrength;

    SKY_TOP = apply_saturation(SKY_TOP, 1 - rainStrength*0.5) * (1 - rainStrength*0.33);
    SKY_GROUND = SKY_GROUND * (1 - rainStrength*0.5);
} 

void get_sun_color() {

    #ifdef DIMENSION_NETHER
    SUN_AMBIENT = to_linear(vec3(0.8, 0.4, 0.3)*NETHER_AMBIENT);
    SUN_DIRECT = vec3(0);
    return;
    #elif defined DIMENSION_END
    SUN_AMBIENT = to_linear(vec3(0.4, 0.34, 0.5)*END_AMBIENT);
    SUN_DIRECT = to_linear(vec3(0.3, 0.23, 0.45));
    return;
    #endif

    SUN_AMBIENT = to_linear(vec3(SUNRISE_AMBIENT*sunriseStrength+NOON_AMBIENT*dayStrength+SUNSET_AMBIENT*sunsetStrength+NIGHT_AMBIENT*nightStrength));
    //SUN_AMBIENT = mix(SUN_AMBIENT, mix(SKY_TOP, SKY_GROUND, 0.7), 0.4);

    float LHeight = sin(sunAngleAtHome * PI * 2); // to_player_pos(sunPosN).y;

    if(LHeight > 0) {
        const vec3 SUNRISE_SUN = to_linear(vec3(SUNRISE_RED, SUNRISE_GREEN, SUNRISE_BLUE));
        const vec3 NOON_SUN = to_linear(vec3(NOON_RED, NOON_GREEN, NOON_BLUE));
        const vec3 SUNSET_SUN = to_linear(vec3(SUNSET_RED, SUNSET_GREEN, SUNSET_BLUE));
        
        SUN_DIRECT = SUNRISE_SUN*sunriseStrength+NOON_SUN*dayStrength+SUNSET_SUN*sunsetStrength;
    }
    else {
        SUN_DIRECT = to_linear(vec3(MOON_RED, MOON_GREEN, MOON_BLUE));

        const float MPI_DIV2 = MOON_PHASE_INFLUENCE/2;
        float MoonPhaseFactor = cos(float(worldDay%8)/8.0*2*PI) * MPI_DIV2 + (1-MPI_DIV2);
        SUN_DIRECT *= MoonPhaseFactor;
    }
    SUN_DIRECT *= smoothstep(0, 0.2, abs(LHeight)); // Fadeout to avoid harsh transition at sun rise/set
    SUN_DIRECT = apply_saturation(SUN_DIRECT, 1 - rainStrength/2) * (1 - rainStrength*0.5);
}



void init_colors() {
    get_sky_color();
    get_sun_color();
}
