#include "/lib/all_the_libs.glsl"

varying vec2 texcoord;

#include "/global/post/taa.glsl"
#include "/global/post/cas.glsl"

// CAS & motionblur

vec3 motion_blur(vec3 Color, vec2 PrevCoord, vec2 CurrentCoord) {
	vec2 Velocity = PrevCoord-CurrentCoord;
	vec2 Offset = Velocity / 4 * MOTION_BLUR_STRENGTH;
	Offset *= 0.01666/frameTime; // Adjust based on framerate. 60 fps is the baseline
	vec3 Blur = Color;

	float Noise = bayer8(gl_FragCoord.xy);
    CurrentCoord += Offset*Noise;

	for(int i = 1; i < 4; i++) {
		Blur += texture2D(colortex0, CurrentCoord).rgb;
		CurrentCoord += Offset;
	}
	return Blur/4;
}

void main() {
    #ifdef IMAGE_SHARPENING
    vec4 Color = vec4(CAS(colortex0), 1);
    #else
    vec4 Color = texture2D(colortex0, texcoord);
    #endif

    #ifdef MOTION_BLUR
	bool IsDH;
    float Depth = get_depth(texcoord, IsDH);
	vec2 PrevCoord = toPrevScreenPos(texcoord, Depth, IsDH);
    
	if(Depth >= 0.56) {
	Color.rgb = motion_blur(Color.rgb, PrevCoord, texcoord);
	}
	#endif

    gl_FragData[0] = Color;
}
